%This code does reflectivity of single layer of Si (dispersion of Si is
%taken into account
clc;
clear all;

global lambda index nair width;

% files must have points at ends of data range


lambda = 400:1:1200;

% load and set indices

%Lines 17, 21, 47, 50, 53  are for amorphous HMM and lines 18, 22, 46, 49, 52 are for crystalline HMM

layer2EPS_F = importdata('Intermix_EPS_11p7nm_GST_HMM_7period_oldtarget_amorphous_model10_fit1_CEase.txt');
% layer2EPS_F = importdata('Intermix_EPS_6p2nm_GST_HMM_7period_oldtarget_crystalline_model9B_fit1_CEase.txt');


layer1NK_F=importdata('GST_NK_24nm_GST_HMM_7period_oldtarget_amorphous_model10_fit1_CEase.txt');
% layer1NK_F=importdata('GST_NK_24nm_GST_HMM_7period_oldtarget_crystalline_model9B_fit1_CEase.txt');

layer4NK_F = importdata('Ge_Palik_WVASE.txt');
layer3NK_F = importdata('Ag_Palik_CompEASE.txt');


layer2EPS = interp1(layer2EPS_F(:,1),layer2EPS_F(:,2),lambda,'spline')+1i*interp1(layer2EPS_F(:,1),layer2EPS_F(:,3),lambda, 'spline'); 
layer1NK = interp1(layer1NK_F(:,1),layer1NK_F(:,2),lambda,'spline')+1i*interp1(layer1NK_F(:,1),layer1NK_F(:,3),lambda, 'spline');
layer3NK = interp1(layer3NK_F(:,1),layer3NK_F(:,2),lambda,'spline')+1i*interp1(layer3NK_F(:,1),layer3NK_F(:,3),lambda, 'spline');
layer4NK = interp1(layer4NK_F(:,1),layer4NK_F(:,2),lambda,'spline')+1i*interp1(layer4NK_F(:,1),layer4NK_F(:,3),lambda, 'spline');



layer2NK=sqrt(layer2EPS);

nair=1*ones(1,length(lambda));
nsubs=1.45*ones(1,length(lambda));

%nspacer = 1.78*ones(1,length(lambda));

% nspacer = interp1(layer1NK_F(:,1),layer1NK_F(:,2),lambda,'spline')+i*interp1(layer1NK_F(:,1),layer1NK_F(:,3),lambda, 'spline');
% lspacer=10;


% t2=6.2;%thickness of intermix in crystalline HMM
t2=11.7; %thickness of intermix in amorphous HMM

% t1=20.9; %thickness of GST in crystalline HMM
t1=18.15;%thickness of GST in amorphous HMM

% t3=11.9;% Thickness of Ag in crystalline HMM
t3=9.15;% Thickness of Ag in amorphous HMM

t4=1;% Thickness of Ge

 index(1,:)=layer1NK;
 width(1)=t1;
index(2,:)=layer2NK;
width(2,:)=t2;
index(3,:)=layer3NK;
width(3,:)=t3;
index(4,:)=layer4NK;
width(4,:)=t4;
index(5,:)=layer1NK;
width(5,:)=t1;
index(6,:)=layer2NK;
width(6,:)=t2;
index(7,:)=layer3NK;
width(7,:)=t3;
index(8,:)=layer4NK;
width(8,:)=t4;
index(9,:)=layer1NK;
width(9,:)=t1;
index(10,:)=layer2NK;
width(10,:)=t2;
index(11,:)=layer3NK;
width(11,:)=t3;
index(12,:)=layer4NK;
width(12,:)=t4;
index(13,:)=layer1NK;
width(13,:)=t1;
index(14,:)=layer2NK;
width(14,:)=t2;
index(15,:)=layer3NK;
width(15,:)=t3;
index(16,:)=layer4NK;
width(16,:)=t4;
index(17,:)=layer1NK;
width(17,:)=t1;
index(18,:)=layer2NK;
width(18,:)=t2;
index(19,:)=layer3NK;
width(19,:)=t3;
index(20,:)=layer4NK;
width(20,:)=t4;
index(21,:)=layer1NK;
width(21,:)=t1;
index(22,:)=layer2NK;
width(22,:)=t2;
index(23,:)=layer3NK;
width(23,:)=t3;
index(24,:)=layer4NK;
width(24,:)=t4;
index(21,:)=layer1NK;
width(21,:)=t1;
index(22,:)=layer2NK;
width(22,:)=t2;
index(23,:)=layer3NK;
width(23,:)=t3;
index(24,:)=layer4NK;
width(24,:)=t4;
index(25,:)=layer1NK;
width(25,:)=t1;
index(26,:)=layer2NK;
width(26,:)=t2;
index(27,:)=layer3NK;
width(27,:)=t3;
index(28,:)=layer4NK;
width(28,:)=t4;

% for k=2:11
%    if (mod(k,2)==0)
%        index(k,:)=layer2NK;
%        width(k)=t1;
%    else
%        index(k,:)=layer1NK;
%         width(k)=t2;
%     end
% end
index = [index; nsubs];
clear nsubs;
clear nspacer;

%%%% start calculations %%%%

%  angles = [0 15 20 25 30 35 40 45 50 55 60 65 70 75 80];
  angles = [35 45 55 65 75];
% angles = [0 70];

for p=1:length(angles)
    angle=angles(p)*pi/180;

    [R_TE(p,:), T_TE(p,:), A_TE(p,:)] = multi_layer_TE(angle);
    [R_TM(p,:), T_TM(p,:), A_TM(p,:)] = multi_layer_TM(angle);
end

spectra(1,:,:) = [lambda;R_TE];
spectra(2,:,:) = [lambda;T_TE];
spectra(3,:,:) = [lambda;A_TE];
spectra(4,:,:) = [lambda;R_TM];
spectra(5,:,:) = [lambda;T_TM];
spectra(6,:,:) = [lambda;A_TM];

f_format = '%6.2f';
for k = 1:length(angles)
    f_format = [f_format, ' %12.8f'];
end
f_format = [f_format, '\n'];

mode_id = ['TE'; 'TM'];
spec_id = ['R'; 'T'; 'A'];

for k = 1:length(mode_id)
    for m = 1:length(spec_id)
        fid = fopen(['Spec_', mode_id(k,:), '_', spec_id(m,:), '.dat'], 'w');
        fprintf(fid, f_format, spectra((k-1)*length(spec_id)+m,:,:));
        fclose(fid);
    end
end

% fid = fopen('trans.dat','w');
%          fprintf(fid, f_format ,[lambda; 1/2*(R_TE + R_TM)]);
% fclose(fid);
% % plot(lambda,[A_TE]);
fid = fopen('trans.dat','w');
%          fprintf(fid, f_format ,[lambda; 1/2*(T_TE + T_TM)]);
% fclose(fid);
% 
% plot(lambda, [1/2*(T_TE + T_TM)]);
% legend(strcat(num2str(angles'), '\circ'));

%  plot(lambda,[R_TE;R_TM]);
%  legend([strcat(num2str(angles'), '\circ TE'); strcat(num2str(angles'), '\circ TM')]);

% plot(lambda,R_TM);
%  legend([strcat(num2str(angles'), '\circ TM')]);

%  plot(lambda,[T_TE;T_TM]);
%  legend([strcat(num2str(angles'), '\circ TE'); strcat(num2str(angles'), '\circ TM')]);

% plot(lambda,[R_TE;T_TE;A_TE]);
% legend(strcat(num2str(angles'), '\circ'));
% legend('R','T','A');

% plotyy(lambda, real(layer1NK), lambda, imag(layer1NK));
% plotyy(lambda, real(layer2NK), lambda, imag(layer2NK));

%for plotting R_TE and R_TM is color maps 
figure;
subplot_tight(2,2,1,[0.04,0.08])
pcolor(lambda,angles,R_TM); hold on; shading interp; contour(lambda,angles,R_TM, 'LineColor','none');
colorbar('northoutside');
ylabel('Angle of incidence (degrees)');
xlabel('Wavelength (nm)');
ax.XTick = [400 600 800 1000 1200 1400];
ax.YTick = [40 50 60 70];
%  title('GST-HMM (Crystalline) - TM Reflection (Calculated - Transfer matrix model)');

subplot_tight(2,2,2,[0.04,0.08])
pcolor(lambda,angles,R_TE); hold on; shading interp; contour(lambda,angles,R_TE, 'LineColor','none');
colorbar('northoutside');
ylabel('Angle of incidence (degrees)');
xlabel('Wavelength (nm)');
ax.XTick = [400 600 800 1000 1200 1400];
ax.YTick = [40 50 60 70];
% title('GST-HMM (Crystalline) - TE Reflection (Calculated - Transfer matrix model)');
